<?php
/**
 * Karzo functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Karzo
 * @since 1.0
 */
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
if( !function_exists('dsvy_theme_setup') ){
function dsvy_theme_setup() {

	/*
	 * Theme translation textdomain
	 * Translations can be filed at WordPress.org. See: https://translate.wordpress.org/projects/wp-themes/karzo
	 */
	load_theme_textdomain( 'karzo', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Add WooCommerce support
	 */
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-lightbox' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	/*
	 *  Image size
	 */
	add_image_size( 'dsvy-img-740x740', 740, 740, true ); // For Karzo service Style 1 - Use
	add_image_size( 'dsvy-img-740x800', 740, 800, true ); // For Karzo service Style 2 - Use
	add_image_size( 'dsvy-img-560x410', 560, 410, true ); // For Karzo service Style 3 - Use
	add_image_size( 'dsvy-img-740x880', 740, 880, true ); // For Karzo service Style 4 - Use

	add_image_size( 'dsvy-img-600x780', 600, 780, true ); // For Karzo Portfolio Style 1 - Use
	add_image_size( 'dsvy-img-770x430', 770, 430, true ); // For Karzo Blog Style 1 - Use

	add_image_size( 'dsvy-img-600x770', 600, 770, true ); // For Karzo team Style 1 - Use
	add_image_size( 'dsvy-img-770x550', 770, 550, true ); // For Karzo Blog - style1 - Use
	add_image_size( 'dsvy-img-770x650', 770, 650, true ); // For Karzo Blog - style3 - Use
	add_image_size( 'dsvy-img-740x450', 740, 450, true ); // For Karzo Blog - style2 - Use

	add_image_size( 'dsvy-img-740x880', 740, 880, true ); // For Karzo Portfolio Style 2 - Use

	add_image_size( 'dsvy-img-800x770', 800, 770, true ); // - Use
	add_image_size( 'dsvy-img-500x700', 500, 700, true ); // For Team Style 1 - Use
	add_image_size( 'dsvy-img-600x800', 600, 800, true ); // - Use
	add_image_size( 'dsvy-img-1030x570', 1030, 570, true ); // For Karzo Portfolio Style 3 - Use
	add_image_size( 'dsvy-img-770x635', 770, 635, true ); // - Use
	add_image_size( 'dsvy-img-770x500', 770, 500, true ); // - Use
	add_image_size( 'dsvy-img-770x9999', 770, 9999, false ); // For Client Logos  - Use
	add_image_size( 'dsvy-img-770x770', 770, 770, true ); //  - Use
	add_image_size( 'dsvy-img-300x300', 300, 300, true ); //  - Use
	add_image_size( 'dsvy-img-500x560', 500, 560, true ); // For Karzo Team  - Use
	add_image_size( 'dsvy-img-800x256', 800, 256, true ); // For Optimize  - Free

	/*
	 *  Editor style
	 */
	add_editor_style();

	// Set the default content width.
	$GLOBALS['content_width'] = 847;

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'designervily-top'		=> esc_attr__( 'Top Menu', 'karzo' ),
		'designervily-footer'	=> esc_attr__( 'Footer Menu', 'karzo' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'script',
			'style',
		)
	);

	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'audio',
		'status',
		'chat',
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

}
}
add_action( 'after_setup_theme', 'dsvy_theme_setup' );

/**
 * Favorites
 */
function dsvy_elementor_add_to_fav(){
	$fav_added = get_user_meta( get_current_user_id(), 'dsvy_add_to_fav', true );
	if( function_exists('is_user_logged_in') && is_user_logged_in() && $fav_added != 'yes' ){
		$data = get_user_meta( get_current_user_id(), 'wp_elementor_editor_user_favorites', true);
		if( is_string($data) ){
			$data = array();
		}
		if( !isset($data['widgets']) ){
			$data['widgets'] = array();
		}
		$existing_widgets = $data['widgets'];
		if( is_array($existing_widgets) ){
			$new_widgets = array(
				'dsvy_blog_element',
				'dsvy_client_element',
				'dsvy_custom_heading',
				'dsvy_event_element',
				'dsvy_fid_element',
				'dsvy_gallery_element',
				'dsvy_heading',
				'dsvy_icon_heading',
				'dsvy_multiple_icon_heading',
				'dsvy_portfolio_element',
				'dsvy_ptable_element',
				'dsvy_service_element',
				'dsvy_static_box_element',
				'dsvy_tabs_element',
				'dsvy_team_element',
				'dsvy_testimonial_element',
				'dsvy_timeline_element',
			);
			if( !empty($existing_widgets) ){
				// Favorites is not empty
				$existing_widgets = array_merge($new_widgets, $existing_widgets );
			} else {
				// Favorites is empty
				$existing_widgets = $new_widgets;
			}
			$data['widgets'] = $existing_widgets;
			update_user_meta( get_current_user_id(), 'wp_elementor_editor_user_favorites', $data);
		}
		update_user_meta( get_current_user_id(), 'dsvy_add_to_fav', 'yes' );
	}
}
add_action( 'init', 'dsvy_elementor_add_to_fav' );
add_action( 'admin_init', 'dsvy_elementor_add_to_fav' );

/* *** Kirki **** */
require_once get_template_directory().'/includes/kirki/kirki.php';

/* *** Envato Theme Setup Wizard settings **** */
require_once get_template_directory().'/setup/envato_setup_init.php';
// Please don't forgot to change filters tag.
// It must start from your theme's name.
add_filter('karzo_theme_setup_wizard_username', 'karzo_set_theme_setup_wizard_username', 10);
if( ! function_exists('karzo_set_theme_setup_wizard_username') ){
    function karzo_set_theme_setup_wizard_username($designervily){
        return esc_attr('designervily');
    }
}

add_filter('karzo_theme_setup_wizard_oauth_script', 'karzo_set_theme_setup_wizard_oauth_script', 10);
if( ! function_exists('karzo_set_theme_setup_wizard_oauth_script') ){
    function karzo_set_theme_setup_wizard_oauth_script($oauth_url){
        return esc_url('https://designervily.com/envato-api/server-script.php');
    }
}

if ( ! defined( 'karzo_theme_version' ) ) {
	define( 'karzo_theme_version', '1.0' );
}

if ( ! class_exists( 'Karzo_Theme_Manager', false ) ) {
	// includes core theme manager class and default settings.
	require_once( get_template_directory() . '/theme_setup_class.php' );
}

if ( class_exists( 'Karzo_Theme_Manager', false ) ) {

	class Karzo_Theme_Manager_Custom extends Karzo_Theme_Manager {

		/**
		 * Holds the current instance of the theme manager
		 *
		 * @var Karzo_Theme_Manager
		 */
		private static $instance = null;

		/**
		 * @return Karzo_Theme_Manager
		 */
		public static function get_instance() {
			if ( ! self::$instance ) {
				self::$instance = new self;
			}

			return self::$instance;
		}

		public function start(){

			add_filter('karzo_default_headers', array($this,'default_headers'));
			add_filter('karzo_custom_header_args', array($this,'karzo_custom_header_args'));
			add_filter('karzo_featured_image_options', array($this,'karzo_featured_image_options'));
			add_filter('karzo_page_options', array($this,'karzo_page_options'));
            add_filter('elementor/widget/render_content', array($this,'elementor_render_content'), 10, 2);

			parent::start();
		}

        public function elementor_render_content( $html, $widget ){
            $settings = $widget->get_settings();
            // this config option is set from theme.json and controlled through the elementor UI
            if(!empty($settings['slider_labels']) && $settings['slider_labels'] == 'labels'){
                // inject our labels into the HTML
                if( preg_match_all('#<figure class="slick-slide-inner">.*alt="([^"]*)".*</figure>#imsU', $html, $matches) ){
                    foreach($matches[0] as $key => $attachment){

                        $image_caption = $matches[1][$key];

                        $image_id = !empty($settings['carousel'][$key]['id']) ? $settings['carousel'][$key]['id'] : false;
                        if($image_id){
                            $image_data = get_post( $image_id );
                            if($image_data) {
                                $image_caption = $image_data->post_excerpt;
                                $image_description = $image_data->post_content;
                            }
                        }
                        $html = str_replace( $attachment, str_replace('<figure class="slick-slide-inner">', '<figure class="slick-slide-inner"><div class="karzo-slider-caption"><div class="inner-content-width"><div><h3>' . esc_html( $image_caption ) . '</h3><div>' . esc_html( $image_description ) . '</div></div></div></div>', $attachment), $html );
                    }
                }
            }
            return $html;
        }

		public function setup_background() {

			// Set up the WordPress core custom background feature.
			add_theme_support( 'custom-background', apply_filters( 'karzo_custom_background_args', array(
				'default-color' => esc_attr('ffffff'),
				'default-image' => '',
			) ) );
		}

		public function karzo_page_options($page_options){
			$page_options['title']['options']['show'] = esc_html__( 'Fancy Title', 'karzo' );
			$page_options['title']['options']['normal'] = esc_html__( 'Normal Title', 'karzo' );

			$page_options['background'] = array(
				'title'		=> esc_html__( 'Page Background', 'karzo' ),
				'options'	=> array(
					'transparent'	=> esc_html__( 'Transparent', 'karzo' ),
					'normal'		=> esc_html__( 'Bordered', 'karzo' ),
				),
				'default'	=> esc_attr('transparent'),
			);

			return $page_options;
		}

		public function setup_images() {
			parent::setup_images();
			add_image_size( 'karzo_gallery_square', 600, 600, true );
			add_image_size( 'karzo_wide_slider', 1500, 385, true );
			add_image_size( 'karzo_blog-large', 1500, 9999, false );
			set_post_thumbnail_size( 800, 410, true );
		}

		public function excerpt_length() {
			return 70;
		}

		public function karzo_featured_image_options($images){
			return array();
		}
		public function karzo_custom_header_args($headerargs){
		    $headerargs['default-image'] = get_template_directory_uri() . '/images/header2-top-lg.png';
		    return $headerargs;
        }
		public function default_headers($headers){
			$headers['header1'] = array(
				'url'           => '%s/images/header1-bottom-lg.png',
				'thumbnail_url'           => '%s/images/header1-bottom-lg.png',
				'description'   => esc_html__( 'Header', 'karzo' )
			);
			$headers['header2'] = array(
				'url'           => '%s/images/header2-top-lg.png',
				'thumbnail_url'           => '%s/images/header2-top-lg.png',
				'description'   => esc_html__( 'Header', 'karzo' )
			);
			$headers['header3'] = array(
				'url'           => '%s/images/header3-top-sml.png',
				'thumbnail_url'           => '%s/images/header3-top-sml.png',
				'description'   => esc_html__( 'Header', 'karzo' )
			);
			return $headers;
		}

		public function after_setup_theme(){

			parent::after_setup_theme();
		}

		public function karzo_blog_date(){
			if(get_post_type() == 'post') {
				?>
                <div class="blog_date">
                    <span class="day"><?php echo get_the_date( 'j' ); ?></span>
                    <span class="month"><?php echo get_the_date( 'M' ); ?></span>
                    <span class="year"><?php echo get_the_date( 'Y' ); ?></span>
                </div>
				<?php
			}
		}

	}

	require_once get_template_directory().'/setup/envato_setup_init.php';

	Karzo_Theme_Manager_Custom::get_instance()->start();
}
/* **** End of Envato Theme Setup Wizard ***** */

if( !function_exists('dsvy_init_calls') ){
function dsvy_init_calls() {
	include( get_template_directory() . '/includes/core.php' );
	if( is_admin() ){
		// Meta boxes
		include( get_template_directory() . '/includes/meta-boxes.php' );
	}
}
}
add_action( 'init', 'dsvy_init_calls' );

// actions
include( get_template_directory() . '/includes/actions.php' );

// Advanced Custom Fields - Fonts Icon Picker
include( get_template_directory() . '/includes/acf/designervily-acf-iconpicker/acf-dsvy_fonticonpicker.php' );

/*
 *  Plugins
 */
require_once get_parent_theme_file_path( '/includes/class-tgm-plugin-activation.php' );
add_action( 'tgmpa_register', 'dsvy_register_required_plugins' );
if( !function_exists('dsvy_register_required_plugins') ){
function dsvy_register_required_plugins() {
	$plugins = array(
		array(
			'name'					=> esc_attr('Slider Revolution'),
			'slug'					=> esc_attr('revslider'),
			'source'				=> get_template_directory() . '/includes/plugins/revslider.zip',
			'version'				=> esc_attr('6.7.14'),
		),
		array(
			'name'					=> esc_attr('Karzo Theme Addons'),
			'slug'					=> esc_attr('karzo-addons'),
			'source'				=> get_template_directory() . '/includes/plugins/karzo-addons.zip',
			'required'				=> true,
			'version'				=> esc_attr('1.9'),
		),
		array(
			'name'					=> esc_attr('Elementor Page Builder'),
			'slug'					=> esc_attr('elementor'),
			'required'				=> true,
		),
		array(
			'name'					=> esc_attr('Advanced Custom Fields'),
			'slug'					=> esc_attr('advanced-custom-fields'),
			'required'				=> true,
		),
		array(
			'name'					=> esc_attr('Max Mega Menu'),
			'slug'					=> esc_attr('megamenu'),
			'required'				=> true,
		),
		array(
			'name'					=> esc_attr('ACF Photo Gallery Field'),
			'slug'					=> esc_attr('navz-photo-gallery'),
			'required'				=> true,
		),
		array(
			'name'					=> esc_attr('Envato Market'),
			'slug'					=> esc_attr('envato-market'),
			'source'				=> get_template_directory() . '/includes/plugins/envato-market.zip',
		),
		array(
			'name'					=> esc_attr('Breadcrumb NavXT'),
			'slug'					=> esc_attr('breadcrumb-navxt'),
		),
		array(
			'name'					=> esc_attr('MailChimp for WordPress'),
			'slug'					=> esc_attr('mailchimp-for-wp'),
		),
		array(
			'name'					=> esc_attr('Contact Form 7'),
			'slug'					=> esc_attr('contact-form-7'),
		),
		array(
			'name'					=> esc_attr('WP Cost Estimation & Payment Forms Builder'),
			'slug'					=> esc_attr('WP_Estimation_Form'),
			'source'				=> get_template_directory() . '/includes/plugins/WP_Estimation_Form.zip',
		),
		array(
			'name'					=> esc_attr('ShareThis Share Buttons'),
			'slug'					=> esc_attr('sharethis-share-buttons'),
		),
		array(
			'name'					=> esc_attr('Twenty20 Image Before-After'),
			'slug'					=> esc_attr('twenty20'),
			'source'				=> get_template_directory() . '/includes/plugins/twenty20.zip',
			'version'	=> esc_attr('1.5.8.1'),
		),
		array(
			'name'					=> esc_attr('Image Hotspot by DevVN'),
			'slug'					=> esc_attr('devvn-image-hotspot'),
		),
	);
	$config = array(
		'id'           => 'karzo',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
	);
	tgmpa( $plugins, $config );
}
}

/**
 *  Merlin Message
 */
if( !function_exists('dsvy_merlin_message') ){
function dsvy_merlin_message() {
	?>
	<div class="dsvy-merlin-message-box notice is-dismissible">
		<div class="dsvy-merlin-message">
			<div class="dsvy-merlin-message-conform">
				<div class="dsvy-merlin-message-conform-inner">
					<div class="dsvy-merlin-message-conform-i">
						<div class="dsvy-merlin-message-conform-col dsvy-merlin-message-conform-img">
							<img src="<?php echo get_template_directory_uri() ?>/includes/images/merlin-message.png" />
						</div>
						<div class="dsvy-merlin-message-conform-col dsvy-merlin-message-conform-text">
							<h3><?php esc_html_e('Are you sure you want to permenently close this wizard?', 'karzo'); ?></h3>
							<p><?php printf( esc_html__('You can start this wizard from %1$s Appearance > Karzo Theme Setup %2$s section', 'karzo') ,dsvy_esc_kses('<strong>') ,dsvy_esc_kses('</strong>') );  ?></p>
							<div class="dsvy-merlin-message-conform-btn">
								<a href="#" class="button button-primary dsvy-disable-merlin-message"><?php esc_html_e('Yes close this message', 'karzo'); ?></a>
								&nbsp; &nbsp;
								<a href="#" class="button dsvy-disable-merlin-message-cancel"><?php esc_html_e('No, keep this message', 'karzo'); ?></a>
							</div>
						</div>
					</div>
				</div>
			</div><!-- .dsvy-merlin-message-conform -->
			<div class="dsvy-merlin-message-inner">
				<div class="dsvy-merlin-message-logo">
					<img src="<?php echo get_template_directory_uri() ?>/includes/images/logo.png" />
				</div>
				<div class="dsvy-merlin-message-vline">
					<div class="dsvy-merlin-message-vline-i"></div>
				</div>
				<div class="dsvy-merlin-message-text">
					<h2><?php esc_html_e('Karzo Theme Setup Wizard', 'karzo'); ?></h2>
					<p><?php esc_html_e('This Karzo theme comes with one-click setup wizard. This step-by-step wizard will install all required plugins, install child theme, install demo content and also import sliders.', 'karzo'); ?></p>
				</div>
				<div class="dsvy-merlin-message-btn">
					<div class="dsvy-merlin-message-btn-i">
						<a href="<?php echo admin_url( 'themes.php?page=karzo-setup' ); ?>" class="button button-primary button-hero load-customize hide-if-no-customize"><?php esc_html_e('Start Theme Setup Wizard', 'karzo'); ?></a>
						<div class="dsvy-merlin-message-small"><a href="#"><?php esc_html_e('Permanently disable this message', 'karzo'); ?></a></div>
					</div>
				</div>
				<div class="clear clearfix clr"></div>
			</div><!-- .dsvy-merlin-message-inner -->
		</div><!-- .dsvy-merlin-message -->
	</div><!-- .notice.is-dismissible -->
	<?php
}
}

if( !function_exists('dsvy_merlin_fresh_setup_call') ){
function dsvy_merlin_fresh_setup_call(){
	$dsvy_merlin_all_done = get_option('dsvy-merlin-all-done');
	if( empty($dsvy_merlin_all_done) ){
		add_action( 'admin_notices', 'dsvy_merlin_message' );
	}
}
}
add_action( 'init', 'dsvy_merlin_fresh_setup_call' );

/**
 *  Merlin message disable ajax call
 */
add_action( 'wp_ajax_dsvy_remove_merlin_message', 'dsvy_remove_merlin_message' );
if( !function_exists('dsvy_remove_merlin_message') ){
function dsvy_remove_merlin_message() {
	update_option( 'dsvy-merlin-all-done', 'yes' );
	echo 'ok';
	wp_die(); // this is required to terminate immediately and return a proper response
}
}

/* Ratings and reviews */
/**
 *  Merlin Message
 */
if( !function_exists('dsvy_ratings_message') ){
function dsvy_ratings_message() {
	?>
	<div class="dsvy-merlin-message-box notice is-dismissible dsvy-merlin-ratings-box">
		<div class="dsvy-merlin-ratings-box-back-link" style="display:none;"><a href="#"><i class="fa fa-chevron-circle-left"></i> <?php esc_html_e('Back','karzo') ?> </a></div>
		<div class="dsvy-merlin-message">
			<!-- Ratings Main Box -->
			<div class="dsvy-merlin-message-inner dsvy-merlin-ratings-box-main" style="display:block;">
				<div class="dsvy-merlin-message-logo">
					<img src="<?php echo get_template_directory_uri() ?>/includes/images/logo.png" />
				</div>
				<div class="dsvy-merlin-message-vline">
					<div class="dsvy-merlin-message-vline-i"></div>
				</div>
				<div class="dsvy-merlin-message-text">
					<h2><?php esc_html_e('Happy with our theme?', 'karzo'); ?></h2>
					<p><?php esc_html_e('We like to know how is your experiance with our theme. If you have any question than you can create ticket on our support site', 'karzo'); ?></p>
				</div>
				<div class="dsvy-merlin-message-btn">
					<div class="dsvy-merlin-message-btn-1">
						<a href="#" class="button button-primary button-hero load-customize hide-if-no-customize dsvy-question-btn"> <i class="fa fa-question-circle"></i> <?php esc_html_e('I have a question or problem', 'karzo'); ?></a>
					</div>
					<div class="dsvy-merlin-message-btn-2 dsvy-happy-btn-container">
						<a href="#" class="button button-primary button-hero load-customize dsvy-happy-btn"> <i class="fa fa-thumbs-o-up"></i> <?php esc_html_e('I am happy with the theme', 'karzo'); ?></a>
					</div>
					<div class="clearfix clear"></div>
					<div class="dsvy-merlin-message-small"><a href="#"><?php esc_html_e('Permanently disable this message', 'karzo'); ?></a></div>
				</div>
				<div class="clear clearfix clr"></div>
			</div><!-- .dsvy-merlin-message-inner -->
			<!-- Ratings Close Permenetly message -->
			<div class="dsvy-merlin-message-conform">
				<div class="dsvy-merlin-message-conform-inner">
					<div class="dsvy-merlin-message-conform-i">
						<div class="dsvy-merlin-message-conform-col dsvy-merlin-message-conform-text">
							<h3><?php esc_html_e('Are you sure you want to permenently close this box?', 'karzo'); ?></h3>
							<div class="dsvy-merlin-message-conform-btn">
								<a href="#" class="button button-primary dsvy-disable-ratings-message"><?php esc_html_e('Yes close this message', 'karzo'); ?></a>
								&nbsp; &nbsp;
								<a href="#" class="button dsvy-disable-ratings-message-cancel"><?php esc_html_e('No, keep this message', 'karzo'); ?></a>
							</div>
						</div>
					</div>
				</div>
			</div><!-- .dsvy-merlin-message-conform -->
			<!-- Questions or problem box -->
			<div class="dsvy-merlin-message-inner dsvy-merlin-ratings-box-questions" style="display:none;">
				<div class="dsvy-merlin-message-text">
					<h2><?php esc_html_e('Have any question or problem?', 'karzo'); ?></h2>
					<p><?php printf( esc_html__('You can read our theme documents to get how to work with the theme. Still not solved, than feel free to contact us via our support site at %1$s', 'karzo'), dsvy_esc_kses('<a href="' . esc_url('hhttps://pbminfotech.support') . '" target="_blank">' . esc_url('https://pbminfotech.support') . '</a>') ); ?></p>
				</div>
				<div class="dsvy-merlin-message-btn">
					<div class="dsvy-merlin-message-btn-2 dsvy-happy-btn-container dsvy-pright-15">
						<a href="<?php echo esc_url('https://karzo-demo.pbminfotech.com/docs/'); ?>" target="_blank" class="button button-primary button-hero load-customize dsvy-ratings-doc-btn"> <i class="fa fa-book"></i> <?php esc_html_e('Karzo Theme Documents', 'karzo'); ?></a>
					</div>
					<div class="dsvy-merlin-message-btn-2 dsvy-happy-btn-container">
						<a href="<?php echo esc_url('https://pbminfotech.support/'); ?>" target="_blank" class="button button-primary button-hero load-customize dsvy-ratings-support-btn"> <i class="fa fa-question-circle"></i> <?php esc_html_e('Go to Designervily support site', 'karzo'); ?></a>
					</div>
					<div class="clearfix clear"></div>
				</div>
				<div class="clear clearfix clr"></div>
			</div><!-- .dsvy-merlin-message-inner -->
			<!-- 5-star ratings box -->
			<div class="dsvy-merlin-message-inner dsvy-merlin-ratings-box-ratings" style="display:none;">
				<div class="dsvy-merlin-message-text">
					<div class="dsvy-merlin-message-arrow-area">
						<h2><?php esc_html_e('Glad to hear you like our theme', 'karzo'); ?></h2>
						<p><?php printf( esc_html__('Thanks for your support. Please provide us 5-star ratings. This will help us a lot.
It just take 1 minute. %1$s', 'karzo'), dsvy_esc_kses('<a href="' . esc_url('https://themeforest.net/downloads') . '" target="_blank">'.esc_html__('Click here to go for review now','karzo').'</a>') ); ?></p>
					</div>
				</div>
				<div class="dsvy-merlin-5star-right-area">
					<img src="<?php echo get_template_directory_uri(); ?>/includes/images/ratings-steps.png" alt="<?php esc_attr_e( 'Ratings Steps', 'karzo' ); ?>" />
				</div>
				<div class="clear clearfix clr"></div>
			</div><!-- .dsvy-merlin-message-inner -->
		</div><!-- .dsvy-merlin-message -->
	</div><!-- .notice.is-dismissible -->
	<?php
}
}

if( !function_exists('dsvy_ratings_call') ){
function dsvy_ratings_call(){
	$show_date			= get_option('dsvy-ratingsbox-show-date');
	$dsvy_merlin_all_done = get_option('dsvy-merlin-all-done');
	if( empty($show_date) ){
		$nextWeek = time() + (7 * 24 * 60 * 60); // One week..
		$nextWeek = strval( $nextWeek );
		update_option('dsvy-ratingsbox-show-date', $nextWeek);
	} else {
		$dsvy_ratings_done	= get_option('dsvy-ratings-done');
		$nextWeek			= get_option('dsvy-ratingsbox-show-date');
		$curr_date			= time();
		if( $nextWeek < $curr_date && empty($dsvy_ratings_done) && $dsvy_merlin_all_done=='yes' ){
			add_action( 'admin_notices', 'dsvy_ratings_message' );
		}
	}
}
}
add_action( 'init', 'dsvy_ratings_call' );

/**
 *  Ratings message disable ajax call
 */
add_action( 'wp_ajax_dsvy_remove_ratings_message', 'dsvy_remove_ratings_message' );
if( !function_exists('dsvy_remove_ratings_message') ){
function dsvy_remove_ratings_message() {
	update_option( 'dsvy-ratings-done', 'yes' );
	echo 'ok';
	wp_die(); // this is required to terminate immediately and return a proper response
}
}

/**
 * Kirki changes
 */
if( !function_exists('dsvy_kirki_changes') ){
function dsvy_kirki_changes(){
	if (!is_customize_preview() ) {
		add_filter( 'kirki_output_inline_styles', '__return_false' );
	}
	add_filter( 'kirki/config', function( $config = array() ) {
		$config['styles_priority'] = 10;
		return $config;
	} );
}
}
add_action( 'init', 'dsvy_kirki_changes' );

/************************************************************* */

//Infinite Scroll
if( !function_exists('dsvy_infinite_scroll') ){
function dsvy_infinite_scroll(){

	if ( ! wp_verify_nonce( $_GET['nonce'], 'dsvy_infinite_scroll_ajax_validation' ) ) {
		return '';
		exit();
	}

	//$loopFile = $_POST['loop_file'];
	$paged = '1';
	if( isset($_GET['page_no']) && !empty($_GET['page_no']) ){
		$paged = $_GET['page_no'];
	}
	$nonce = '';
	if( isset($_GET['nonce']) && !empty($_GET['nonce']) ){
		$nonce = $_GET['nonce'];
	}
	$show = '3';
	if( isset($_GET['show']) && !empty($_GET['show']) ){
		$show = $_GET['show'];
	}
	$cpt = 'post';
	if( isset($_GET['cpt']) && !empty($_GET['cpt']) ){
		$cpt_name = $cpt = $_GET['cpt'];
		if( $cpt == 'blog' ){
			$cpt_name = 'post';
		} else if($cpt == 'team'){
			$cpt_name = 'dsvy-team-member';
		} else {
			$cpt_name = 'dsvy-'.$cpt;
		}
	}
	$columns = '3';
	if( isset($_GET['columns']) && !empty($_GET['columns']) ){
		$columns = $_GET['columns'];
	}
	$style = '1';
	if( isset($_GET['style']) && !empty($_GET['style']) ){
		$style = $_GET['style'];
	}
	$orderby = '';
	if( isset($_GET['orderby']) && !empty($_GET['orderby']) ){
		$orderby = $_GET['orderby'];
	}
	$order = '';
	if( isset($_GET['order']) && !empty($_GET['order']) ){
		$order = $_GET['order'];
	}
	$from_category = '';
	if( isset($_GET['from_category']) && !empty($_GET['from_category']) ){
		$from_category = $_GET['from_category'];
	}
	$offset = 0;
	if( isset($_GET['offset']) && !empty($_GET['offset']) ){
		$offset = $_GET['offset'];
	}

	if( $paged>1 ){
		$offset = $offset + ( ($paged-1) * $show);
	}

	// Preparing $args
	$args = array(
		'post_type'				=> $cpt_name,
		'status'				=> 'publish',
		'posts_per_page'		=> $show,
		'ignore_sticky_posts'	=> true,
		'offset'				=> $offset,
	);

	// From selected category/group
	if( !empty($from_category) ){
		$from_category = explode(',', $from_category);
		$args['tax_query'] = array(
			array(
				'taxonomy' => dsvy_get_category_of_cpt($cpt),
				'field'    => 'slug',
				'terms'    => $from_category,
			),
		);
	};

	if( !empty($orderby) && $orderby!='none' ){
		$args['orderby'] = $orderby;
		if( !empty($order) ){
			$args['order'] = $order;
		}
	}

	// Wp query to fetch posts
	$posts = new \WP_Query( $args );

	if ( $posts->have_posts() ) {

		$odd_even		= 'odd';
		$col_odd_even	= 'odd';
		$x				= 1;
		while ( $posts->have_posts() ) {
			$return = '';
			$posts->the_post();

			// Template
			if( file_exists( locate_template( '/theme-parts/'.esc_attr($cpt).'/'.esc_attr($cpt).'-style-'.esc_attr($style).'.php', false, false ) ) ){

				$return .= dsvy_element_block_container( array(
					'position'		=> 'start',
					'column'		=> $columns,
					'cpt'			=> $cpt,
					'taxonomy'		=> dsvy_get_category_of_cpt($cpt),
					'style'			=> $style,
					'odd_even'		=> $odd_even,
					'col_odd_even'	=> $col_odd_even,
				) );

				ob_start();
				$r = include( locate_template( '/theme-parts/'.esc_attr($cpt).'/'.esc_attr($cpt).'-style-'.esc_attr($style).'.php', false, false ) );
				$return .= ob_get_contents();
				ob_end_clean();

				$return .= dsvy_element_block_container( array(
					'position'	=> 'end',
				) );

			}

			echo dsvy_esc_kses($return);

			// odd or even
			if( $odd_even == 'odd' ){ $odd_even = 'even'; } else { $odd_even = 'odd'; }
			if( $x % $columns == 0 ){
				if( $col_odd_even == 'odd' ){ $col_odd_even = 'even'; } else { $col_odd_even = 'odd'; }
			}
			$x++;

		}
		?>

		<?php

	}
	wp_reset_postdata();

	wp_die(); // this is required to terminate immediately and return a proper response
}
}
add_action('wp_ajax_dsvy_infinite_scroll', 'dsvy_infinite_scroll'); // for logged in user
add_action('wp_ajax_nopriv_dsvy_infinite_scroll', 'dsvy_infinite_scroll'); // if user not logged in

add_filter('event_manager_event_wpem_column','dsvy_change_wpem_column_listing');
if( !function_exists('dsvy_change_wpem_column_listing') ){
function dsvy_change_wpem_column_listing($number){

	$column = dsvy_get_base_option('event-column');
	if( empty($column) ){
		$column = '3';
	}

	if( $column != '12' ){
		$column = substr($column, 0, 1);
	}

	if( !in_array( $column, array('3','4','6','12') ) ){
		$column = '3';
	}

	return $column;
}
}