<?php
/**
 *
 * @package WordPress
 * @subpackage karzo
 * @since 1.0
 * @version 1.0
 */
$header_phone = dsvy_get_base_option('header-phone');
?>

<div class="dsvy-header-overlay">
	<?php get_template_part( 'theme-parts/header/pre-header',	dsvy_get_base_option('header-style') ); ?>
	<div class="dsvy-header-height-wrapper" style="min-height:<?php echo dsvy_get_base_option('header-height'); ?>px;">
		<div class="dsvy-main-header-area <?php dsvy_header_class(); ?> <?php dsvy_header_bg_class(); ?>">
			<div class="dsvy-header-content d-flex justify-content-between align-items-center">
				<div class="dsvy-logo-menuarea">
					<div class="site-branding dsvy-logo-area">
						<div class="wrap">
							<?php echo dsvy_logo(); ?><!-- Logo area -->
						</div><!-- .wrap -->
					</div><!-- .site-branding -->			
				</div><!-- .justify-content-between -->
				<div class="dsvy-menuarea">
					<!-- Top Navigation Menu -->
					<div class="navigation-top">
						<div class="dsvy-mobile-menu-bg"></div>
						<button id="menu-toggle" class="nav-menu-toggle">
							<i class="dsvy-base-icon-menu-1"></i>
						</button>
							<div class="wrap">
								<nav id="site-navigation" class="main-navigation dsvy-navbar <?php dsvy_nav_class(); ?>" aria-label="<?php esc_attr_e( 'Top Menu', 'karzo' ); ?>">
									<?php wp_nav_menu( array(
										'theme_location' => 'designervily-top',
										'menu_id'        => 'dsvy-top-menu',
										'menu_class'     => 'menu',
									) ); ?>
								</nav><!-- #site-navigation -->
							</div><!-- .wrap -->
					</div><!-- .navigation-top -->
					<div class="dsvy-right-box">
						<div class="dsvy-search-cart-box">	
							<?php dsvy_header_search(); ?>					
							<?php dsvy_cart_icon(); ?>									
						</div>
						<div class="dsvy-button-box d-flex align-items-center">	
							<?php dsvy_header_button(); ?>	
							<?php dsvy_header_button_second(); ?>	
						</div>	
					</div>
				</div>
			</div><!-- .container -->
		</div><!-- .dsvy-header-wrapper -->
	</div><!-- .dsvy-header-height-wrapper -->
</div>
