<?php
// Getting all options with values
$all_data = dsvy_get_all_option_array();

$gradient_first = '#ffff00';
$gradient_last  = '#ffff00';
$responsive_breakpoint	= '1200';
$preheader_responsive	= '1200';
if( function_exists('dsvy_get_base_option') ){
	$gradient_colors = dsvy_get_base_option('gradient-color');
	$gradient_first  = ( !empty($gradient_colors['first']) ) ? $gradient_colors['first'] : '#ffff00' ;
	$gradient_last   = ( !empty($gradient_colors['last'])  ) ? $gradient_colors['last']  : '#ffff00' ;

	$responsive_breakpoint	= dsvy_get_base_option('responsive-breakpoint');
	$preheader_responsive	= dsvy_get_base_option('preheader-responsive');
}

// new code start here
$new_all_data = array();
foreach( $all_data as $key=>$val ){
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$new_all_data[$key] = $val;
}

// allowed to create css variables
$allowed = array(
	'global-color',
	'secondary-color',
	'gradient-color',
	'white-color',
	'blackish-color',
	'light-bg-color',
	'blackish-bg-color',
	'header-height',
	'sticky-header-height',
	'responsive-breakpoint',
	'main-menu-typography',
	'main-menu-sticky-color',
	'preheader-bgcolor-custom',
	'header-background-color',
	'menu-background-color',
	'sticky-header-background-color',
	'link-color',
	'header-height',
	'logo-height',
	'responsive-logo-height',
	'titlebar-height',
	'sticky-logo-height',
	'light-bg-color',
	'footer-1-col-width',
	'footer-2-col-width',
	'footer-3-col-width',
	'footer-4-col-width',
);
?>

:root {
<?php
foreach( $new_all_data as $key=>$val ){

	if( in_array( $key, array( 'sticky-logo-height', 'responsive-logo-height', 'header-height', 'sticky-header-height', 'logo-height', 'responsive-logo-height', 'responsive-breakpoint', 'titlebar-height' ) ) ){
		$val .= 'px';
	}
	if( in_array( $key, array( 'footer-1-col-width', 'footer-2-col-width', 'footer-3-col-width', 'footer-4-col-width' ) ) ){
		$val .= '%';
	}

	if( in_array( $key, $allowed ) ){
		if( is_array($val) ){
			foreach( $val as $val_key=>$val_val ){
				if( !empty($val_val) ){
				?>
	--dsvy-karzo-<?php echo esc_attr($key); ?>-<?php echo esc_attr($val_key); ?>: <?php echo esc_attr($val_val); ?>;
<?php
				}
			}
		} else {
		?>
	--dsvy-karzo-<?php echo esc_attr($key); ?>: <?php echo esc_attr($val) ?>;
<?php

		}
	}
}

// value is color for the option
$colors = array(
	'global-color',
	'secondary-color',
	'white-color',
	'blackish-color',
	'light-bg-color',
	'blackish-bg-color',
	'main-menu-typography',
);

foreach( $new_all_data as $key=>$val ){
	if( in_array( $key, $colors ) ){
		if( is_array($val) && isset($val['color']) ){
			$key .= '-color';
			$val = $val['color'];
		}
		?>
	--dsvy-karzo-<?php echo esc_attr($key); ?>-rgb: <?php echo esc_attr( dsvy_hex2rgb_code($val) ) ?>;
<?php
	}
}
?>

} /* CSS :root ends here */

<?php echo dsvy_all_options_values('background'); ?>
<?php echo dsvy_all_options_values('typography'); ?>

/* --------------------------------------
 * Common header bg
 * ---------------------------------------*/

.site-header .dsvy-sticky-header.dsvy-sticky-bg-color-globalcolor{
	background-color: var(--dsvy-karzo-global-color);
}
.site-header .dsvy-sticky-header.dsvy-sticky-bg-color-secondarycolor{
	background-color: var(--dsvy-karzo-secondary-color);
}
.site-header .dsvy-sticky-header.dsvy-sticky-bg-color-blackish{
	background-color: var(--dsvy-karzo-blackish-bg-color);
}
.site-header .dsvy-sticky-header.dsvy-sticky-bg-color-white{
	background-color: var(--dsvy-karzo-white-color);
}
.site-header .dsvy-sticky-header.dsvy-sticky-bg-color-light{
	background-color: var(--dsvy-karzo-light-bg-color);
}

/* --------------------------------------
 * Custom background color and text color
 * ---------------------------------------*/
/* Custom preheader background color */
.dsvy-pre-header-wrapper.dsvy-bg-color-custom{
	background-color: var(--dsvy-karzo-preheader-bgcolor-custom);
}
/* Custom Header background color */
.dsvy-header-wrapper.dsvy-bg-color-custom{
	background-color: var(--dsvy-karzo-header-background-color);
}
/* Custom Menu area background color */
.dsvy-header-menu-area.dsvy-bg-color-custom{
	background-color: var(--dsvy-karzo-menu-background-color);
}
/* sticky-header-background-color */
.site-header.dsvy-fixed-header .dsvy-sticky-bg-color-custom{
	background-color: var(--dsvy-karzo-sticky-header-background-color);
}
/* Custom Menu text color */
body:not(.mega-menu-designervily-top) .dsvy-sticky-header .dsvy-navbar div > ul > li > a{
	color: var(--dsvy-karzo-main-menu-sticky-color);
}

/* --------------------------------------
 * A tag
 * ---------------------------------------*/
a{
	color: var(--dsvy-karzo-link-color-normal);
}
a:hover{
	color: var(--dsvy-karzo-link-color-hover);
}

/* --------------------------------------
 * site-title
 * ---------------------------------------*/
.site-title {
	height: var(--dsvy-karzo-header-height);
}
.site-title img.dsvy-main-logo{
	max-height: var(--dsvy-karzo-logo-height);
}
.site-title img.dsvy-responsive-logo{
	max-height: var(--dsvy-karzo-responsive-logo-height);
}

/*=== Sticky logo ===*/
.site-header.dsvy-fixed-header .site-title img.dsvy-main-logo{
	max-height: var(--dsvy-karzo-sticky-logo-height);
}

/* --------------------------------------
 * Global color
 * ---------------------------------------*/
.dsvy-color-globalcolor,
.dsvy-globalcolor,
.globalcolor{
	color: var(--dsvy-karzo-global-color) ;
}

/* --------------------------------------
 * Global Color
 * ---------------------------------------*/
/*=== Global BG Color ===*/
.site-header .dsvy-sticky-on.dsvy-sticky-bg-color-globalcolor,
.site-header .dsvy-bg-color-globalcolor,
.dsvy-bg-color-globalcolor{
    background-color: var(--dsvy-karzo-global-color);
}

/*=== Global Text Color ===*/
.dsvy-globalcolor,
.dsvy-skincolor{
	color: var(--dsvy-karzo-global-color);
}

/*=== Global Border Color ===*/
.post.sticky{
	border-color: var(--dsvy-karzo-global-color);
}

/* --------------------------------------
 * Secondary Color
 * ---------------------------------------*/

/*=== Secondary BG Color ===*/
.dsvy-bg-color-secondarycolor,
.dsvy-bg-color-secondary{
	background-color: var(--dsvy-karzo-secondary-color);
}

/*=== Secondary Text Color ===*/
.dsvy-color-secondarycolor{
	color: var(--dsvy-karzo-secondary-color);
}

/* --------------------------------------
 *  Gradient Color
 * ---------------------------------------*/

/*=== Gradient BG Color ===*/
.elementor-widget-button.dsvy-btn-color-gradient .elementor-button,
.dsvy-bg-color-gradient{
	background-image: -ms-linear-gradient(right, var(--dsvy-karzo-gradient-color-first) 0%, var(--dsvy-karzo-gradient-color-last) 100%);
	background-image: linear-gradient(to right, var(--dsvy-karzo-gradient-color-first) , var(--dsvy-karzo-gradient-color-last) );
}
.dsvy-footer-section.dsvy-bg-color-gradientcolor:before{
	background-image: -ms-linear-gradient(right, var(--dsvy-karzo-gradient-color-first) 0%, var(--dsvy-karzo-gradient-color-last) 100%) !important;
	background-image: linear-gradient(to right, var(--dsvy-karzo-gradient-color-first) , var(--dsvy-karzo-gradient-color-last) ) !important;
}
.elementor-widget-button.dsvy-btn-color-gradient .elementor-button {
	border-image-slice: 1;
	border-image-source: linear-gradient(to left, var(--dsvy-karzo-gradient-color-first), var(--dsvy-karzo-gradient-color-last));
}

/* --------------------------------------
 *  Light Color
 * ---------------------------------------*/
.dsvy-btn-style-flat.dsvy-btn-color-light .elementor-button,
.dsvy-bg-color-light{
	background-color: var(--dsvy-karzo-light-bg-color);
}

.dsvy-btn-style-text.dsvy-btn-color-light .elementor-button{
	color: var(--dsvy-karzo-light-bg-color);
}
.dsvy-btn-style-outline.dsvy-btn-color-light .elementor-button{
	border-color: var(--dsvy-karzo-light-bg-color);
	color: var(--dsvy-karzo-light-bg-color);
} 
body.single.single-dsvy-portfolio .site-content-contain,
body.single.single-dsvy-team-member .site-content-contain,
.page.dsvy-sidebar-exists .site-content-contain,
.archive.dsvy-sidebar-exists .site-content-contain,
.blog .site-content-contain, .single.blog .site-content-contain,
body.single.dsvy-sidebar-exists .site-content-contain {
	background-color: var(--dsvy-karzo-white-color);
}

/* --------------------------------------
 * White color
 * ---------------------------------------*/
.dsvy-elementor-bg-color-globalcolor .dsvy-btn-color-blackish .elementor-button:hover{
	background-color:#fff;
}

/* --------------------------------------
 * Woocommerce
 * ---------------------------------------*/
.dsvy-cart-wrapper.dsvy-show-cart-amount-no .woocommerce-Price-amount.amount{
	display: none !important;
}

.dsvy-mobile-menu-bg{
	display: none;
}

/* --------------------------------------
 * dsvy-responsive-icons
 * ---------------------------------------*/
 .dsvy-responsive-icons{
	position: absolute;
	top: 30px;
	left: 20px;
	display: none;
}
.admin-bar .dsvy-responsive-icons{
	top: 75px;
}
.dsvy-responsive-icons > div{
	margin: 0 10px;
}
.dsvy-responsive-icons > div:first-child{
	margin-left: 0;
}

.dsvy-responsive-icons .dsvy-cart-wrapper a {
	position: relative;
	padding-left: 30px;
}
.dsvy-responsive-icons .dsvy-cart-wrapper.dsvy-show-cart-amount-no a {
	padding-left: 25px;
}
.dsvy-responsive-icons .dsvy-cart-wrapper a:before {
	content: "\e83b";
	font-family: "designervily-base-icons";
	font-size: 20px;
	line-height: 20px;
	position: absolute;
	left: 0;
	top: 50%;
	-webkit-transform: translateY(-50%);
	-ms-transform: translateY(-50%);
	-moz-transform: translateY(-50%);
	transform: translateY(-50%);
	font-weight: 400;
	-webkit-transition: all .25s ease-in-out;
	transition: all .25s ease-in-out;
}
.dsvy-responsive-icons .dsvy-cart-wrapper .dsvy-cart-count {
	position: absolute;
	top: -21px;
	left: 2px;
	background-color: var(--dsvy-karzo-global-color);
	color: var(--dsvy-karzo-white-color);
	line-height: 20px;
	width: 20px;
	text-align: center;
	border-radius: 50%;
	font-size: 13px;
}

/*====================================  End Dynamic color  ====================================*/

/* * * * *  MENU AND BREAKPOINT CSS  * * * * * */
/*====================================  Max Width for dynamic breakpoint  ====================================*/
@media (max-width: <?php echo esc_attr($responsive_breakpoint); ?>px){

	.dsvy-header-top-area > .container{
		position: relative;
	}
	.site-header .dsvy-sticky-header {
		display: none !important;
	}
	.dsvy-header-info-inner,
	.something{
		display: none;
	}
	.navbar-expand-lg .navbar-nav{
		-ms-flex-direction: unset !important;
		flex-direction: unset !important;
	}
	.dsvy-header-menu-area-inner,
	.dsvy-navbar{
		display: block !important;
	}
	.nav-menu-toggle{
		display: block;
		position: absolute;
		right: 0px;
		top: 50%;
		-webkit-transform: translateY(-50%);
		-ms-transform: translateY(-50%);
		transform: translateY(-50%);
		background-color: transparent;
		padding: 0;
		font-size: 35px;
		line-height: 35px;
		color: #2c2c2c;
		width: 40px;
	}
	.dsvy-navbar > div{
		background-color: #fff;
	}
	.sub-menu{
		display: none;
	}
	.dsvy-header-menu-area-wrapper{
		min-height: auto !important;
	}
	.closepanel{
		position: absolute;
		z-index: 99;
		right: 20px;
		margin-left: -20px;
		top: 30px;
		display: block;
		width: 30px;
		height: 30px;
		line-height: 30px;
		border-radius: 50%;
		text-align: center;
		cursor: pointer;
		font-size: 25px;
		color: var(--dsvy-karzo-secondary-color);
		border: 0;
		-webkit-transition: all 300ms ease;
		transition: all 300ms ease;
	}
	.admin-bar .closepanel{
		top: 72px;
	}

	/*=== Responsive menu ===*/
	.dsvy-mobile-menu-bg{
		display: block;
	}
	.dsvy-responsive-icons{
		display: flex;
		align-items: center;
	}
	.dsvy-mobile-menu-bg{
		position: fixed;
		right: 0;
		top: 0;
		width: 0%;
		height: 100%;
		z-index: 99;
		background: rgba(0,0,0,0.90);
		-webkit-transform: translateX(101%);
		-ms-transform: translateX(101%);
		transform: translateX(101%);
		transition: all 900ms ease;
		-moz-transition: all 900ms ease;
		-webkit-transition: all 900ms ease;
		-ms-transition: all 900ms ease;
		-o-transition: all 900ms ease;
		-webkit-transition-delay: 300ms;
		-moz-transition-delay: 300ms;
		-ms-transition-delay: 300ms;
		-o-transition-delay: 300ms;
		transition-delay: 300ms;
	}
	.active .dsvy-mobile-menu-bg{
		opacity: 1;
		width: 100%;
		visibility: visible;
		transition: all 900ms ease;
		-moz-transition: all 900ms ease;
		-webkit-transition: all 900ms ease;
		-ms-transition: all 900ms ease;
		-o-transition: all 900ms ease;
		-webkit-transform: translateX(0%);
		-ms-transform: translateX(0%);
		transform: translateX(0%);
	}
	.dsvy-navbar > div {
		background-color: #fff;
		position: fixed;
		top: 0;
		right: -400px;
		z-index: 1000;
		width: 300px;
		height: 100%;
		padding: 0;
		display: block;
		transition: all 900ms ease;
		-moz-transition: all 900ms ease;
		-webkit-transition: all 900ms ease;
		-ms-transition: all 900ms ease;
		-o-transition: all 900ms ease;
		-webkit-transform: translateX(400px);
		-ms-transform: translateX(400px);
		transform: translateX(400px);
		opacity: 0;
	}
	.dsvy-navbar > div.active {
		right: 0px;
		-webkit-transform: translateX(0);
		-ms-transform: translateX(0);
		transform: translateX(0);
		visibility: visible;
		opacity: 1;
		overflow-y: scroll;
		-webkit-transition-delay: 600ms;
		-moz-transition-delay: 600ms;
		-ms-transition-delay: 600ms;
		-o-transition-delay: 600ms;
		transition-delay: 600ms;
		opacity: 1;
	}
	.dsvy-navbar > div > ul{
		padding: 90px 0;
	}
	.admin-bar .dsvy-navbar > div > ul{
		padding-top: 125px;
	}
	.dsvy-navbar > div > ul li a {
		color: #000 !important;
		padding: 15px 25px;
		height: auto;
		display: inline-block;
	}
	.dsvy-navbar > div > ul ul {
		padding-left: 1em;
		overflow: hidden;
		display: none;
	}
	ul .sub-menu.show,
	ul .children.show {
		display: block;
	}
	.dsvy-navbar li{
		position: relative;
	}
	.dsvy-navbar ul.menu > li{
		border-bottom: 1px solid rgba(0, 0, 0, 0.10);
	}
	.sub-menu-toggle{
		display: block;
		position: absolute;
		right: 25px;
		top: 15px;
		cursor: pointer;
		color: rgba(0, 0, 0, 0.80);
	}
	.dsvy-navbar ul ul{
		background-color: transparent !important;
	}
	.dsvy-mobile-search{
		display: block;
	}
	.dsvy-mobile-search .dsvy-header-search-btn{
		display: block;
		position: absolute;
		right: 60px;
		top: 50%;
		-webkit-transform: translateY(-50%);
		-ms-transform: translateY(-50%);
		transform: translateY(-50%);
	}
	/*=== Responsive Logo ===*/
	.dsvy-responsive-logo-yes .dsvy-sticky-logo,
	.dsvy-responsive-logo-yes .dsvy-main-logo{
		display: none;
	}
	.dsvy-responsive-logo-yes .dsvy-responsive-logo{
		display: inline-block;
	}

	/*=== Responsive header background color ===*/
	.dsvy-responsive-header-bgcolor-globalcolor .dsvy-header-wrapper{
		background-color: var(--dsvy-karzo-global-color) !important;
	}
	.dsvy-responsive-header-bgcolor-white .dsvy-header-wrapper{
		background-color: #fff !important;
	}
	.dsvy-responsive-header-bgcolor-blackish .dsvy-header-wrapper{
		background-color: var(--dsvy-karzo-blackish-bg-color) !important;
	}
	.dsvy-responsive-header-bgcolor-white{
		background-color: #fff!important;
	}
	.dsvy-responsive-header-bgcolor-blackish{
		background-color: var(--dsvy-karzo-blackish-bg-color)!important;
	}
	.dsvy-responsive-header-bgcolor-globalcolor{
		background-color: var(--dsvy-karzo-global-color)!important;
	}
}
/*====================================  End Max Break Point  ====================================*/
/*====================================  Min Width for dynamic breakpoint  ====================================*/

@media (min-width: <?php echo esc_attr($responsive_breakpoint+1); ?>px){
	.site-header .dsvy-sticky-header {
		position: fixed;
		opacity: 0;
		visibility: hidden;
		background: #fff;
		left: 0px;
		top: 0px;
		box-shadow: 0 10px 20px rgb(0 0 0 / 20%);
		width: 100%;
		z-index: 0;
		transition: all 200ms ease;
		-moz-transition: all 200ms ease;
		-webkit-transition: all 200ms ease;
		-ms-transition: all 200ms ease;
		-o-transition: all 200ms ease;
	}
	.site-header.dsvy-fixed-header .dsvy-sticky-header {
		z-index: 999;
		opacity: 1;
		visibility: visible;
		-ms-animation-name: fadeInDown;
		-moz-animation-name: fadeInDown;
		-op-animation-name: fadeInDown;
		-webkit-animation-name: fadeInDown;
		animation-name: fadeInDown;
		-ms-animation-duration: 300ms;
		-moz-animation-duration: 300ms;
		-op-animation-duration: 300ms;
		-webkit-animation-duration: 300ms;
		animation-duration: 300ms;
		-ms-animation-timing-function: linear;
		-moz-animation-timing-function: linear;
		-op-animation-timing-function: linear;
		-webkit-animation-timing-function: linear;
		animation-timing-function: linear;
		-ms-animation-iteration-count: 1;
		-moz-animation-iteration-count: 1;
		-op-animation-iteration-count: 1;
		-webkit-animation-iteration-count: 1;
		animation-iteration-count: 1;
	}
	.admin-bar .site-header .dsvy-sticky-header {
		top: 32px;
	}
	.dsvy-responsive-logo{
		display: none;
	}
	.nav-menu-toggle,
	.something{
		display: none;
	}
	.dsvy-sticky-on .site-title img.dsvy-main-logo,
	.site-title img.dsvy-sticky-logo{
		max-height: var(--dsvy-karzo-sticky-logo-height);
	}
	body .dsvy-navbar > div > ul > li,
	body .dsvy-navbar > div > ul > li > a{
		line-height: var(--dsvy-karzo-header-height) !important;
		height: var(--dsvy-karzo-header-height) !important;
	}
	.dsvy-sticky-header .dsvy-navbar > div > ul > li,
	.dsvy-sticky-header .dsvy-navbar > div > ul > li > a,
	.dsvy-sticky-header .site-title {
		line-height: var(--dsvy-karzo-sticky-header-height) !important;
		height: var(--dsvy-karzo-sticky-header-height) !important;
	}
	.dsvy-navbar ul > li > ul > li.current-menu-item > a,
	.dsvy-navbar ul > li > ul li.current_page_item > a,
	.dsvy-navbar ul > li > ul li.current_page_ancestor > a,
	.dsvy-navbar > div > ul > li:hover > a,
	.dsvy-navbar > div > ul > li.current_page_item > a,
	.dsvy-navbar > div > ul > li.current-menu-parent > a {
		color: var(--dsvy-karzo-global-color);
	}
	.dsvy-navbar ul > li > ul li.current_page_item > a:before,
	.dsvy-navbar ul > li > ul li.current_page_ancestor > a:before,
	.dsvy-navbar ul > li > ul li.current_page_parent > a:before{
		background-color: var(--dsvy-karzo-global-color);
	}
	.dsvy-navbar ul > li > ul li:hover > a {
		color: var(--dsvy-karzo-global-color) !important;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar > div > ul {
		position: relative;
		z-index: 597;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar > div > ul > li {
		float: left;
		min-height: 1px;
		vertical-align: top;
		position: relative;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar > div > ul ul {
		visibility: hidden;
		position: absolute;
		top: 100%;
		left: 0;
		z-index: 598;
	}
	.dsvy-navbar ul > li:hover > ul{
		z-index: 600;
	}
	.dsvy-navbar > div > ul li ul.dsvy-nav-left{
		left: inherit;
		right: 0;
	}
	.dsvy-navbar > div > ul li ul ul.dsvy-nav-left{
		left: -100%;
		right: 0;
		-webkit-transition: none;
		transition: none;
	}
	.dsvy-navbar > div > ul ul li {
		float: none;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar > div > ul ul ul {
		top: 0;
		left: 100%;
		width: 190px;
	}
	.dsvy-navbar > div > ul ul {
		padding: 8px 10px;
	}
	.dsvy-navbar > div > ul ul li {
		font-weight: normal;
		padding: 10px 25px;
	}
	.dsvy-navbar a {
		display: block;
		line-height: 1em;
		text-decoration: none;
	}

	/* Custom CSS Styles */
	.dsvy-navbar > ul {
		*display: inline-block;
	}
	.dsvy-navbar:after,
	.dsvy-navbar ul:after {
		content: '';
		display: block;
		clear: both;
	}
	.dsvy-navbar ul {
		text-transform: uppercase;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar ul ul {
		min-width: 230px;
		opacity: 0;
		visibility: hidden;
		border-top: 3px solid var(--dsvy-karzo-global-color);
		-webkit-box-shadow: -1px 17px 20px -10px rgb(0 0 0 / 33%);
		-moz-box-shadow: -1px 17px 20px -10px rgba(0,0,0,0.33);
		-webkit-transition: all 300ms linear 0ms;
		-khtml-transition: all 300ms linear 0ms;
		-moz-transition: all 300ms linear 0ms;
		-ms-transition: all 300ms linear 0ms;
		-o-transition: all 300ms linear 0ms;
		transition: all 300ms linear 0ms;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar ul > li:hover > ul {
		visibility: visible;
		opacity: 1;
		clip: inherit;
	}
	.dsvy-navbar ul > li > ul > li > a{
		position: relative;
		display: table-cell;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar ul > li > ul > li > a:before {
		position: absolute;
		content: '';
		left: 0px;
		bottom: -2px;
		width: 0px;
		height: 1px;
		background-color: var(--dsvy-karzo-global-color);
		-webkit-transition: all .500s ease-in-out;
		transition: all .500s ease-in-out;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar ul > li > ul > li:hover > a:before{
		width: 100%;
	}
	.dsvy-navbar ul ul a {
		padding: 0px;
	}
	.dsvy-navbar ul ul ul {
		border-top: 0 none;
	}
	.dsvy-navbar ul ul li {
		position: relative;
	}
	.dsvy-navbar ul li.last ul {
		left: auto;
		right: 0;
	}
	.dsvy-navbar ul li.last ul ul {
		left: auto;
		right: 99.5%;
	}
	body:not(.mega-menu-designervily-top) .dsvy-navbar div > ul > li > a{
		padding: 0 20px;
		margin: 0;
	}

	/* Dropdown Menu ( Globalcolor )*/
	.dsvy-max-mega-menu-override #page #site-navigation.dsvy-navbar.dsvy-dropdown-active-color-globalcolor .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu ul:not(.menu) > li.mega-current-menu-item > a,
	.dsvy-navbar.dsvy-dropdown-active-color-globalcolor ul > li > ul > li.current-menu-item > a,
	.dsvy-navbar.dsvy-dropdown-active-color-globalcolor ul > li > ul li.current_page_item > a,
	.dsvy-navbar.dsvy-dropdown-active-color-globalcolor ul > li > ul li.current_page_ancestor > a,

	/* Main Menu ( Globalcolor )*/
	.dsvy-navbar.dsvy-main-active-color-globalcolor > div > ul > li:hover > a,
	.dsvy-navbar.dsvy-main-active-color-globalcolor > div > ul > li.current_page_item > a,
	.dsvy-navbar.dsvy-main-active-color-globalcolor > div > ul > li.current-menu-parent > a,
	.dsvy-sticky-header .dsvy-navbar.dsvy-main-active-color-globalcolor > div > ul > li.current-menu-parent > a{
		color: var(--dsvy-karzo-global-color);
	}
	/* Dropdown Menu ( Secondarycolor )*/
	.dsvy-navbar.dsvy-dropdown-active-color-secondarycolor ul > li > ul > li.current-menu-item > a,
	.dsvy-navbar.dsvy-dropdown-active-color-secondarycolor ul > li > ul li.current_page_item > a,
	.dsvy-navbar.dsvy-dropdown-active-color-secondarycolor ul > li > ul li.current_page_ancestor > a,

	/* Main Menu ( Secondarycolor )*/
	.dsvy-navbar.dsvy-main-active-color-secondarycolor > div > ul > li:hover > a,
	.dsvy-navbar.dsvy-main-active-color-secondarycolor > div > ul > li.current_page_item > a,
	.dsvy-navbar.dsvy-main-active-color-secondarycolor > div > ul >li.current-menu-parent > a{
		color: var(--dsvy-karzo-secondary-color);
	}
	.dsvy-header-menu-area .dsvy-navbar div > ul > li,
	.dsvy-header-menu-area .dsvy-navbar div > ul > li > a,
	.dsvy-header-menu-area{
		height: 62px;
		line-height: 62px !important;
	}
	.dsvy-header-menu-area.dsvy-sticky-on .dsvy-navbar div > ul > li,
	.dsvy-header-menu-area.dsvy-sticky-on .dsvy-navbar div > ul > li > a,
	.dsvy-header-menu-area.dsvy-sticky-on{
		height: 62px;
		line-height: 62px !important;
	}
	.dsvy-header-menu-area{
		position: relative;
		z-index: 10;
	}
	.dsvy-navbar > div > ul > li.menu-item-has-children,
	.dsvy-navbar > div > ul > li.page_item_has_children{
		padding-right: 10px;
	}
	.dsvy-navbar > div > ul > li.menu-item-has-children > a:after,
	.dsvy-navbar > div > ul > li.page_item_has_children > a:after{
		font-family: "designervily-base-icons";
		font-size: 10px;
		content: "\e811";
		position: absolute;
		top: 1px;
		right: 10px;
		font-weight: 500;
	}
	.dsvy-top-menu-more-than-six .dsvy-navbar > div > ul > li.menu-item-has-children > a:after,
	.dsvy-top-menu-more-than-six .dsvy-navbar > div > ul > li.page_item_has_children > a:after{
		right: 5px;
	}
	.dsvy-navbar > div > ul > li.menu-item-has-children:hover:after,
	.dsvy-navbar > div > ul > li.page_item_has_children:hover{
		color: var(--dsvy-karzo-global-color);
	}

	/*=== dsvy-search-cart-box ===*/
	.dsvy-search-cart-box .dsvy-cart-wrapper a,
	.dsvy-search-cart-box .dsvy-header-search-btn a{
		font-size: 20px;
	}
	.dsvy-search-cart-box .dsvy-cart-wrapper a .amount{
		font-size: 15px;
	}
	.dsvy-search-cart-box{
		display: flex;
		align-items: center;
		position: relative;
	}
	.dsvy-search-cart-box > *{
		padding: 0 20px;
		position: relative;
	}
	.dsvy-search-cart-box > *:nth-child(2)::after{
		content: '';
		width: 1px;
		height: 30px;
		background-color: rgba(var(--dsvy-karzo-blackish-bg-color-rgb), 0.20);
		position: absolute;
		left: 0px;
		top: 50%;
		-webkit-transform: translateY(-50%);
		-ms-transform: translateY(-50%);
		transform: translateY(-50%);
	}
	.dsvy-search-cart-box .dsvy-cart-wrapper a,
	.dsvy-search-cart-box .dsvy-cart-details{
		position: relative;
	}
	.dsvy-search-cart-box .dsvy-cart-count{
		position: absolute;
		top: -12px;
		left: -16px;
		background-color: var(--dsvy-karzo-global-color);
		color: #fff;
		height: 16px;
		line-height: 16px;
		width: 16px;
		text-align: center;
		border-radius: 50%;
		font-size: 10px;
	}
	.dsvy-search-cart-box .dsvy-cart-wrapper a:before {
		content: "\e87f";
		font-family: "designervily-base-icons";
		font-size: 20px;
		line-height: 20px;
		font-weight: normal;
		-webkit-transition: all .25s ease-in-out;
		transition: all .25s ease-in-out;
	}
}
/*====================================  End Min Break Point  ====================================*/

<?php if( !empty($preheader_responsive) ){ ?>
@media screen and (max-width: <?php echo esc_html($preheader_responsive); ?>px) {
	.dsvy-pre-header-wrapper{
		display: none;
	}
}
<?php } ?>
<?php
$footer_column	= dsvy_get_base_option('footer-column');
if( $footer_column=='custom' ) :
	$footer_column_1	= dsvy_get_base_option('footer-1-col-width');
	$footer_column_2	= dsvy_get_base_option('footer-2-col-width');
	$footer_column_3	= dsvy_get_base_option('footer-3-col-width');
	$footer_column_4	= dsvy_get_base_option('footer-4-col-width');
	?>
	@media screen and (min-width: 992px) {
		<?php if( !empty($footer_column_1) && $footer_column_1!='hide' ) : ?>
		.site-footer .dsvy-footer-widget.dsvy-footer-widget-col-1{
			-ms-flex: 0 0 var(--dsvy-karzo-footer-1-col-width);
			flex: 0 0 var(--dsvy-karzo-footer-1-col-width);
			max-width: var(--dsvy-karzo-footer-1-col-width);
		}
		<?php endif; ?>
		<?php if( !empty($footer_column_2) && $footer_column_2!='hide' ) : ?>
		.site-footer .dsvy-footer-widget.dsvy-footer-widget-col-2{
			-ms-flex: 0 0 var(--dsvy-karzo-footer-2-col-width);
			flex: 0 0 var(--dsvy-karzo-footer-2-col-width);
			max-width: var(--dsvy-karzo-footer-2-col-width);
		}
		<?php endif; ?>
		<?php if( !empty($footer_column_3) && $footer_column_3!='hide' ) : ?>
		.site-footer .dsvy-footer-widget.dsvy-footer-widget-col-3{
			-ms-flex: 0 0 var(--dsvy-karzo-footer-3-col-width);
			flex: 0 0 var(--dsvy-karzo-footer-3-col-width);
			max-width: var(--dsvy-karzo-footer-3-col-width);
		}
		<?php endif; ?>
		<?php if( !empty($footer_column_4) && $footer_column_4!='hide' ) : ?>
		.site-footer .dsvy-footer-widget.dsvy-footer-widget-col-4{
			-ms-flex: 0 0 var(--dsvy-karzo-footer-4-col-width);
			flex: 0 0 var(--dsvy-karzo-footer-4-col-width);
			max-width: var(--dsvy-karzo-footer-4-col-width);
		}
		<?php endif; ?>
	}
<?php endif; ?>
