<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Karzo
 * @since 1.0
 * @version 1.2
 */
// Class list
$style			= dsvy_get_base_option('portfolio-single-style');
$single_style	= get_post_meta( get_the_ID(), 'dsvy-portfolio-single-view', true );
if( !empty($single_style) ){ $style = $single_style; }
$class_list		= 'dsvy-portfolio-single-style-'.$style;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $class_list ); ?>>
	<div class="dsvy-portfolio-single">
		<div class="dsvy-single-project-content-wrapper">
			<div class="row">
				<div class="col-md-12">	
				<?php dsvy_get_featured_data( array( 'featured_img_only' => false, 'size' => 'dsvy-img-770x520' ) ); ?>
				</div> 
				<div class="col-md-12">	  
				<div  class="dsvy-single-project-details-list">
						<h4><?php esc_html_e('Project info', 'karzo'); ?></h4>
						<?php
							// Short Description
							$short_desc = get_post_meta( get_the_ID(), 'dsvy-short-description', true );
							if( !empty($short_desc) ){
								?>
								<div class="dsvy-short-description">
									<?php echo do_shortcode($short_desc); ?>
								</div> 
								<?php
							}
						?>  

					<?php dsvy_portfolio_details_list(); ?>	

				</div>
			</div>
		</div>
		</div>
		<div class="row">
			<div class="col-md-12">				
				<div class="dsvy-entry-content">
					<?php
					/* translators: %s: Name of current post */
					the_content( sprintf(
						'',
						get_the_title()
					) );
					?>
				</div><!-- .entry-content -->	
			</div>

		</div>
		<?php
		// Prev Next Post Link
		$cpt_name = dsvy_get_base_option('portfolio-cpt-singular-title');
		$next_post = get_next_post();
		$previous_post = get_previous_post();
		$prevThumbnail = isset( $previous_post->ID ) ? get_the_post_thumbnail($previous_post->ID,'thumbnail') : '';
		$nextThumbnail = isset( $next_post->ID ) ? get_the_post_thumbnail($next_post->ID,'thumbnail') : '';
		the_post_navigation( array(
			'prev_text' => dsvy_esc_kses( '<span class="dsvy-portfolio-nav-thumbnail">' . $prevThumbnail .'<span class="dsvy-portfolio-nav-icon"><i class=" dsvy-base-icon-left-small"></i></span> </span> <span class="dsvy-portfolio-nav-wrapper"><span class="dsvy-portfolio-nav-head">' . sprintf( esc_attr__('Previous', 'karzo') , $cpt_name ) . '</span>' ) . dsvy_esc_kses( '<span class="dsvy-portfolio-nav nav-title">%title</span> </span>' ),
			'next_text' => dsvy_esc_kses( '<span class="dsvy-portfolio-nav-wrapper"><span class="dsvy-portfolio-nav-head">' . sprintf( esc_attr__('Next', 'karzo') , $cpt_name ) . '</span>' ) . dsvy_esc_kses( '<span class="dsvy-portfolio-nav nav-title">%title</span> </span> <span class="dsvy-portfolio-nav-thumbnail"> <span class="dsvy-portfolio-nav-icon"><i class=" dsvy-base-icon-right-small"></i></span>' . $nextThumbnail .'</span>' ),
		) );
		?>
	</div>
</article><!-- #post-## -->
<?php dsvy_related_portfolio(); ?>
<?php dsvy_edit_link(); ?>